package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.data.PayPalGenerateClientTokenData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.payment.AdapterException;
import de.hybris.platform.servicelayer.user.UserService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_LIVE_ENVIRONMENT;
import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.any;
import static org.mockito.Mockito.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalClientTokenServiceTest {

    private static final String PAYPAL_API_URL = "paypalApiUrl";
    private static final String CLIENT_ID = "testClientId";
    private static final String SECRET_KEY = "testSecretKey";
    private static final String VAULT_CUSTOMER_ID = "testVaultCustomerId";
    private static final String IDENTITY_GENERATE_TOKEN_URL = "identity/generate-token";
    private static final String BLANK_LINE = "";
    private static final String ENVIRONMENT_TYPE = "sandbox";

    @Mock
    private PayPalConfigurationService defaultPayPalConfigurationService;

    @Mock
    private UserService userService;

    @Mock
    private RestTemplate restTemplate;

    @Mock
    private CustomerModel customerModel;

    @Mock
    private ResponseEntity<PayPalGenerateClientTokenData> response;

    @InjectMocks
    private DefaultPayPalClientTokenService unit;

    private PayPalGenerateClientTokenData responseBody;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        responseBody = new PayPalGenerateClientTokenData();
    }

    @Test
    public void shouldReturnClientToken() {
        when(defaultPayPalConfigurationService.getPayPalApiUrl()).thenReturn(PAYPAL_API_URL);
        when(defaultPayPalConfigurationService.getEnvironmentType()).thenReturn(PAYPAL_LIVE_ENVIRONMENT);
        when(defaultPayPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(defaultPayPalConfigurationService.getSecretKey()).thenReturn(SECRET_KEY);

        when(userService.getCurrentUser()).thenReturn(customerModel);
        when(customerModel.getVaultCustomerId()).thenReturn(VAULT_CUSTOMER_ID);

        when(restTemplate.postForEntity(eq(PAYPAL_API_URL + IDENTITY_GENERATE_TOKEN_URL), any(), eq(PayPalGenerateClientTokenData.class))).thenReturn(response);
        when(response.getBody()).thenReturn(responseBody);

        assertEquals(responseBody, unit.getClientToken());
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterExceptionWhenReceiveHttpClientError() {
        when(defaultPayPalConfigurationService.getPayPalApiUrl()).thenReturn(PAYPAL_API_URL);
        when(defaultPayPalConfigurationService.getEnvironmentType()).thenReturn(ENVIRONMENT_TYPE);
        when(defaultPayPalConfigurationService.getClientID()).thenReturn(CLIENT_ID);
        when(defaultPayPalConfigurationService.getSecretKey()).thenReturn(SECRET_KEY);

        when(userService.getCurrentUser()).thenReturn(customerModel);
        when(customerModel.getVaultCustomerId()).thenReturn(BLANK_LINE);

        when(restTemplate.postForEntity(eq(PAYPAL_API_URL + IDENTITY_GENERATE_TOKEN_URL), any(), eq(PayPalGenerateClientTokenData.class))).thenThrow(HttpClientErrorException.class);

        unit.getClientToken();
    }
}