/*

 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCartDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.order.impl.DefaultCartService;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.doNothing;

@UnitTest
public class DefaultPayPalCartServiceTest {

    private static final String ORDER_ID = "orderId";
    private static final String CORRELATION_ID= "correlationId";

    @Mock
    private PayPalCartDao cartDao;

    @Mock
    private ModelService modelService;

    @Mock
    private CartService cartService;

    @Mock
    private CartModel entryModel;

    @Mock
    private DefaultCartService defaultCartService;

    @Spy
    @InjectMocks
    private DefaultPayPalCartService unit;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldReturnCartWhenSuchCartByPaypalOrderIdIsPresent() {

        when(cartDao.getCartByPayPalOrderIdForLocalPayments(ORDER_ID)).thenReturn(Optional.of(entryModel));

        assertNotNull(unit.getCartByPayPalOrderIdForLocalPayments(ORDER_ID).get());
    }

    @Test
    public void shouldReturnEmptyWhenThereIsNoSuchCartByPaypalOrderId() {

        when(cartDao.getCartByPayPalOrderIdForLocalPayments(ORDER_ID)).thenReturn(Optional.empty());

        assertTrue(unit.getCartByPayPalOrderIdForLocalPayments(ORDER_ID).isEmpty());
    }

    @Test
    public void setPayPalOrderIdForCurrentCart(){
        final CartModel entryModel = new CartModel();

        doReturn(entryModel).when(unit).getSessionCart();

        unit.setPayPalOrderIdForCurrentCart(ORDER_ID);

        verify(modelService).save(entryModel);
        assertEquals(ORDER_ID, entryModel.getPayPalOrderId());
    }

    @Test
    public void saveCorrelationIdTest() {

        doReturn(entryModel).when(unit).getSessionCart();
        doNothing().when(modelService).save(entryModel);

        unit.saveCorrelationId(CORRELATION_ID);

        verify(unit).getSessionCart();
        verify(entryModel).setPayPalClientMetadataId(CORRELATION_ID);
        verify(modelService).save(entryModel);
    }
}
