package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCarrierDao;
import com.paypal.hybris.core.model.PayPalCarrierModel;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.List;
import java.util.Optional;

import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalCarrierServiceTest {

    private AutoCloseable closable;
    @Mock
    private PayPalCarrierModel payPalCarrierModel;
    @Mock
    private PayPalCarrierDao payPalCarrierDao;
    @InjectMocks
    private DefaultPayPalCarrierService unit;

    @Before
    public void setup() {
        closable = MockitoAnnotations.openMocks(this);
    }

    @Test
    public void shouldReturnAllCarriers() {
        when(payPalCarrierDao.getAllCarriers()).thenReturn(Optional.of(List.of(payPalCarrierModel)));
        Assert.assertEquals(payPalCarrierModel, unit.getAllCarriers().get(0));
    }

    @After
    public void close() throws Exception {
        closable.close();
    }

}
