package com.paypal.hybris.core.processcommands.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.processengine.BusinessProcessService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalCreateLinkEmailNotificationProcessCommandTest {

    @Mock
    private BusinessProcessService businessProcessService;

    @Mock
    private StoreFrontCustomerProcessModel storeFrontCustomerProcessModel;

    @InjectMocks
    private PayPalCreateLinkEmailNotificationProcessCommand unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldCreateProcess() {
        when(businessProcessService.createProcess(anyString(), anyString())).thenReturn(storeFrontCustomerProcessModel);

        assertEquals(storeFrontCustomerProcessModel, unit.createProcess());

    }
}