package com.paypal.hybris.core.listener;

import com.paypal.hybris.core.enums.PayPalEmailEvent;
import com.paypal.hybris.core.event.PayPalEmailNotificationEvent;
import com.paypal.hybris.core.processcommands.PayPalCreateProcessCommand;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.basecommerce.model.site.BaseSiteModel;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.core.model.c2l.CurrencyModel;
import de.hybris.platform.core.model.c2l.LanguageModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Map;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalEmailNotificationEventListenerTest {

    private static final String UID = "UID";

    @Mock
    private Map<PayPalEmailEvent, PayPalCreateProcessCommand> processCommandMap;

    @Mock
    private BusinessProcessService businessProcessService;

    @Mock
    private ModelService modelService;

    @Mock
    private BaseStoreService baseStoreService;

    @Mock
    private BaseSiteService baseSiteService;

    @Mock
    private CommonI18NService commonI18NService;

    @Mock
    private UserService userService;

    @Mock
    private StoreFrontCustomerProcessModel notificationProcess;

    @Mock
    private PayPalCreateProcessCommand createProcessCommand;

    @Mock
    private BaseStoreModel baseStoreModel;

    @Mock
    private BaseSiteModel baseSiteModel;

    @Mock
    private LanguageModel languageModel;

    @Mock
    private CurrencyModel currencyModel;

    @Mock
    private CustomerModel customerModel;

    @InjectMocks
    private PayPalEmailNotificationEventListener unit;

    private PayPalEmailNotificationEvent event;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        event = new PayPalEmailNotificationEvent(UID, PayPalEmailEvent.LINK);
    }

    @Test
    public void shouldExecutePayPalEmailNotificationEventListenerEvent() {
        when(processCommandMap.get(event.getPayPalEmailEvent())).thenReturn(createProcessCommand);
        when(createProcessCommand.createProcess()).thenReturn(notificationProcess);

        when(baseStoreService.getCurrentBaseStore()).thenReturn(baseStoreModel);
        when(commonI18NService.getCurrentLanguage()).thenReturn(languageModel);
        when(commonI18NService.getCurrentCurrency()).thenReturn(currencyModel);
        when(baseSiteService.getCurrentBaseSite()).thenReturn(baseSiteModel);
        when(userService.getUserForUID(UID)).thenReturn(customerModel);

        unit.onEvent(event);

        verify(modelService).save(notificationProcess);
        verify(businessProcessService).startProcess(notificationProcess);
    }
}