package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.ItemModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import de.hybris.platform.servicelayer.interceptor.PersistenceOperation;
import de.hybris.platform.servicelayer.internal.model.impl.ModelValueHistory;
import de.hybris.platform.servicelayer.model.ItemModelContextImpl;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.List;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalOrderPrepareInterceptorTest {

    @Mock
    private OrderModel order;

    @Mock
    private ItemModel itemModel;

    @Mock
    private InterceptorContext ctx;

    @Mock
    private PayPalCreditCardPaymentInfoModel paymentInfo;

    @Mock
    private PaymentInfoModel paymentInfoModel;

    @Mock
    private ModelValueHistory history;

    @Mock
    private ItemModelContextImpl context;

    @Mock
    private PaymentTransactionModel paymentTransactionModel;

    @Spy
    @InjectMocks
    private DefaultPayPalOrderPrepareInterceptor unit;

    private List<PaymentTransactionModel> paymentTransactionModels;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        paymentTransactionModels = List.of(paymentTransactionModel);
    }

    @Test
    public void shouldExecutePayPalOrderPrepareOnPrepareMethod() throws InterceptorException {
        when(ctx.isNew(order)).thenReturn(Boolean.TRUE);
        when(order.getItemModelContext()).thenReturn(context);
        when(context.getValueHistory()).thenReturn(history);
        when(ctx.isModified(any(), any())).thenReturn(Boolean.FALSE);

        when(order.getPaymentInfo()).thenReturn(paymentInfo);

        when(order.getPaymentTransactions()).thenReturn(paymentTransactionModels);

        unit.onPrepare(order, ctx);

        verify(ctx).registerElementFor(paymentTransactionModel, PersistenceOperation.SAVE);
    }

    @Test
    public void shouldNotRegisterElementWhenCtxIsNotNew() throws InterceptorException {
        when(ctx.isNew(order)).thenReturn(Boolean.FALSE);
        when(order.getItemModelContext()).thenReturn(context);
        when(context.getValueHistory()).thenReturn(history);
        when(ctx.isModified(any(), any())).thenReturn(Boolean.FALSE);

        unit.onPrepare(order, ctx);

        verify(ctx, never()).registerElementFor(any(), any());
    }

    @Test
    public void shouldNotRegisterElementWhenPaymentInfoNotPayPalCreditCard() throws InterceptorException {
        when(ctx.isNew(order)).thenReturn(Boolean.TRUE);
        when(order.getItemModelContext()).thenReturn(context);
        when(context.getValueHistory()).thenReturn(history);
        when(ctx.isModified(any(), any())).thenReturn(Boolean.FALSE);

        when(order.getPaymentInfo()).thenReturn(paymentInfoModel);

        unit.onPrepare(order, ctx);

        verify(ctx, never()).registerElementFor(any(), any());
    }

    @Test
    public void shouldNotRegisterElementWhenModelIsNotInstanceOfOrderModel() throws InterceptorException {
        unit.onPrepare(itemModel, ctx);

        verify(ctx, never()).registerElementFor(any(), any());
    }
}