package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.enums.PayPalFunding;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.Set;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalConfigurationOnInitDefaultsInterceptorTest {

    @Mock
    private InterceptorContext interceptorContext;

    @Mock
    private PayPalConfigurationModel payPalConfigurationModel;

    @InjectMocks
    private DefaultPayPalConfigurationOnInitDefaultsInterceptor unit;


    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldExecutePayPalConfigurationOnInitDefaultsOnInitDefaultsMethod() throws InterceptorException {
        Set<PayPalFunding> defaultFundingOnBillingPage = unit.getDefaultFundingOnBillingPage();
        Set<PayPalFunding> defaultFundingOnExpressCheckout = unit.getDefaultFundingOnExpressCheckout();

        when(payPalConfigurationModel.getPayPalFundingOnBillingPage()).thenReturn(Set.of(PayPalFunding.PAYPAL));
        when(payPalConfigurationModel.getPayPalFundingOnExpressCheckout()).thenReturn(Set.of(PayPalFunding.PAYPAL));

        unit.onInitDefaults(payPalConfigurationModel, interceptorContext);

        assertEquals(payPalConfigurationModel.getPayPalFundingOnBillingPage(), defaultFundingOnBillingPage);
        assertEquals(payPalConfigurationModel.getPayPalFundingOnExpressCheckout(), defaultFundingOnExpressCheckout);

        verify(payPalConfigurationModel).setPayPalFundingOnExpressCheckout(defaultFundingOnExpressCheckout);
        verify(payPalConfigurationModel).setPayPalFundingOnBillingPage(defaultFundingOnBillingPage);
    }
}