package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.enums.LocalPaymentFunding;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Arrays;
import java.util.stream.Collectors;

import static org.mockito.Mockito.verify;

@UnitTest
public class DefaultLocalPaymentsConfigurationOnInitDefaultsInterceptorTest {

    @Mock
    private LocalPaymentsConfigurationModel localPaymentsConfigurationModel;

    @Mock
    private InterceptorContext interceptorContext;

    @InjectMocks
    private DefaultLocalPaymentsConfigurationOnInitDefaultsInterceptor unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldExecuteLocalPaymentsConfigurationOnInitDefaultsMethod() throws InterceptorException {
        unit.onInitDefaults(localPaymentsConfigurationModel, interceptorContext);

        verify(localPaymentsConfigurationModel).setFundingsOnBillingPage(Arrays.stream(LocalPaymentFunding.values()).collect(Collectors.toSet()));
    }
}