package com.paypal.hybris.core.exception;

import com.paypal.http.Headers;
import com.paypal.http.exceptions.HttpException;
import de.hybris.bootstrap.annotations.UnitTest;
import io.netty.util.internal.StringUtil;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;

import java.io.IOException;
import java.util.Date;

import static org.assertj.core.api.Assertions.assertThat;

@UnitTest
public class PayPalAdapterExceptionTest {
	private static final String HEADER_DATE_KEY = "Date";
	private static final String HEADER_DEBUG_ID_KEY = "Paypal-Debug-Id";
	private static final String HEADER_DEBUG_ID = "DebugId";
	private static final String HEADER_DATE = "Mon, 30 May 2024 15:45:00 GMT";
	private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
	private static final long DATE_MS = 1717083900000L;

	@Before
	public void setUp() {
		MockitoAnnotations.openMocks(this);
	}

	@Test
	public void shouldCreateExceptionWithDebugIdAndDateWhenTheyArePresentInHeaders() {
		Date date = new Date();
		date.setTime(DATE_MS);
		Headers headers = new Headers();
		headers.header(HEADER_DATE_KEY, HEADER_DATE);
		headers.header(HEADER_DEBUG_ID_KEY, HEADER_DEBUG_ID);
		IOException parentException = new HttpException(ERROR_MESSAGE, HttpStatus.UNPROCESSABLE_ENTITY.value(), headers);

		PayPalAdapterException exception = new PayPalAdapterException(parentException);

		assertThat(exception.getCreateDate()).isEqualTo(date);
		assertThat(exception.getDebugId()).isEqualTo(HEADER_DEBUG_ID);

	}

	@Test
	public void shouldCreateExceptionWithEmptyDebugIdIdAndCurrentDateWhenTheyAreMissingInHeaders() {
		Date date = new Date();
		date.setTime(DATE_MS);
		Headers headers = new Headers();
		IOException parentException = new HttpException(ERROR_MESSAGE, HttpStatus.UNPROCESSABLE_ENTITY.value(), headers);

		PayPalAdapterException exception = new PayPalAdapterException(parentException);

		assertThat(exception.getCreateDate()).isNotEqualTo(date);
		assertThat(exception.getDebugId()).isEqualTo(StringUtil.EMPTY_STRING);

	}
}