package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.model.PayPalCarrierModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.exceptions.ModelNotFoundException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.List;
import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPaypalCarrierDaoTest {
    private AutoCloseable closable;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @Mock
    private PayPalCarrierModel payPalCarrierModel;
    @Mock
    private SearchResult<Object> searchResult;

    @InjectMocks
    private DefaultPayPalCarrierDao unit;


    @Before
    public void setUp() throws Exception {
        closable = MockitoAnnotations.openMocks(this);
    }

    @After
    public void close() throws Exception {
        closable.close();
    }

    @Test
    public void shouldReturnAllCarriers() {
        when(flexibleSearchService.search(any(FlexibleSearchQuery.class))).thenReturn(searchResult);
        when(searchResult.getResult()).thenReturn(List.of(payPalCarrierModel));

        Optional<List<PayPalCarrierModel>> carriers = unit.getAllCarriers();

        assertTrue(carriers.isPresent());
        assertEquals(payPalCarrierModel, carriers.get().get(0));
    }

    @Test
    public void shouldReturnEmptyOptionalWhenMissingCarriers() {
        when(flexibleSearchService.search(any(FlexibleSearchQuery.class))).thenThrow(ModelNotFoundException.class);

        Optional<List<PayPalCarrierModel>> carriers = unit.getAllCarriers();

        assertFalse(carriers.isPresent());
    }

}
