package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.model.PaypalAccessTokenModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.servicelayer.exceptions.ModelNotFoundException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;

import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;


import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPaypalAccessTokenDaoTest {

    private static final String TEST_GUID = "testguid";

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @Mock
    private PaypalAccessTokenModel paypalAccessTokenModel;

    @InjectMocks
    private DefaultPaypalAccessTokenDao unit;


    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldFindAccessTokenByGuid() {
        when(flexibleSearchService.searchUnique(any(FlexibleSearchQuery.class))).thenReturn(paypalAccessTokenModel);

        Optional<PaypalAccessTokenModel> foundAccessToken = unit.findAccessTokenByGuid(TEST_GUID);

        assertTrue(foundAccessToken.isPresent());
        assertEquals(paypalAccessTokenModel, foundAccessToken.get());
    }


    @Test
    public void shouldNotFindAccessTokenByGuid() {
        when(flexibleSearchService.searchUnique(any(FlexibleSearchQuery.class))).thenThrow(ModelNotFoundException.class);

        Optional<PaypalAccessTokenModel> foundAccessToken = unit.findAccessTokenByGuid(TEST_GUID);

        assertTrue(foundAccessToken.isEmpty());
    }

}