package com.paypal.hybris.core.dao.impl;

import com.paypal.hybris.core.dao.impl.DefaultPayPalLogoDao;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.catalog.model.CatalogUnawareMediaModel;
import de.hybris.platform.servicelayer.exceptions.SystemException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalLogoDaoTest {

    private static final String LOGO_CODE = "logoCode";
    private static final String CODE = "code";
    private static final String FIND_LOGO_QUERY = "SELECT {" + CatalogUnawareMediaModel.PK + "} FROM {"
            + CatalogUnawareMediaModel._TYPECODE + "} WHERE {" + CatalogUnawareMediaModel.CODE + "}=?code";

    @Mock
    private FlexibleSearchService flexibleSearchService;
    @Mock
    private CatalogUnawareMediaModel mediaModel;
    private FlexibleSearchQuery fQuery;

    @InjectMocks
    private DefaultPayPalLogoDao unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        fQuery = new FlexibleSearchQuery(FIND_LOGO_QUERY);
        fQuery.addQueryParameter(CODE, LOGO_CODE);
    }

    @Test
    public void shouldFindExistingLogo() {
        when(flexibleSearchService.searchUnique(fQuery)).thenReturn(mediaModel);

        unit.findExistingLogo(LOGO_CODE);

        verify(flexibleSearchService).searchUnique(fQuery);
    }

    @Test
    public void shouldThrowSystemsException() {
        when(flexibleSearchService.searchUnique(fQuery)).thenThrow(SystemException.class);

        Optional<CatalogUnawareMediaModel> existingLogo = unit.findExistingLogo(LOGO_CODE);

        assertEquals(Optional.empty(), existingLogo);
    }

}