/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import de.hybris.platform.servicelayer.search.SearchResult;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.List;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.Mockito.anyMap;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalCustomerAccountDaoTest {

    private static final String PAYER_ID = "payerId";
    private static final String VAULT_ID = "vaultId";

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @Mock
    private CustomerModel customerModel;

    @Mock
    SearchResult result;

    @InjectMocks
    private DefaultPayPalCustomerAccountDao unit;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldFindCustomerByPayPalPayerId() {
        when(flexibleSearchService.search(anyString(), anyMap())).thenReturn(result);

        when(result.getCount()).thenReturn(1);
        when(result.getResult()).thenReturn(List.of(customerModel));

        assertNotNull(unit.findCustomerByPayPalPayerId(PAYER_ID));
    }

    @Test
    public void shouldNotFindCustomerByPayPalPayerId() {
        when(flexibleSearchService.search(anyString(), anyMap())).thenReturn(result);

        when(result.getCount()).thenReturn(0);

        assertNull(unit.findCustomerByPayPalPayerId(PAYER_ID));
    }

    @Test
    public void shouldFindCustomerByVaultId(){
        when(flexibleSearchService.search(anyString(), anyMap())).thenReturn(result);

        when(result.getCount()).thenReturn(1);
        when(result.getResult()).thenReturn(List.of(customerModel));

        assertNotNull(unit.findCustomerByPayPalPayerId(VAULT_ID));
    }

    @Test
    public void shouldNotFindCustomerByVaultId(){
        when(flexibleSearchService.search(anyString(), anyMap())).thenReturn(result);

        when(result.getCount()).thenReturn(0);

        assertNull(unit.findCustomerByPayPalPayerId(VAULT_ID));
    }
}
