/**
 *
 */
package com.paypal.hybris.core.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.servicelayer.exceptions.ModelNotFoundException;
import de.hybris.platform.servicelayer.search.FlexibleSearchQuery;
import de.hybris.platform.servicelayer.search.FlexibleSearchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@UnitTest
public class DefaultPayPalCartDaoTest {

    private static final String TEST_ID = "testId";

    private CartModel cartModel;

    @Mock
    private FlexibleSearchService flexibleSearchService;

    @InjectMocks
    private DefaultPayPalCartDao payPalCartDao;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        List<CartModel> carts = new ArrayList<>();
        cartModel = new CartModel();
        carts.add(cartModel);

    }

    @Test
    public void shouldReturnCartByPayPalOrderIdForLocalPayments() {
        when(flexibleSearchService.searchUnique(any(FlexibleSearchQuery.class))).thenReturn(cartModel);

        Optional<CartModel> result = payPalCartDao.getCartByPayPalOrderIdForLocalPayments(TEST_ID);
        assertEquals(cartModel, result.get());
    }

    @Test
    public void shouldNotReturnCartByPayPalOrderIdForLocalPayments() {
        when(flexibleSearchService.searchUnique(any(FlexibleSearchQuery.class))).thenThrow(ModelNotFoundException.class);

        Optional<CartModel> result = payPalCartDao.getCartByPayPalOrderIdForLocalPayments(TEST_ID);

        assertTrue(result.isEmpty());
    }

}
