package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import com.paypal.hybris.data.PayPalCustomerData;
import com.paypal.hybris.data.PayPalPaymentSource;
import com.paypal.hybris.data.PayPalSavePaymentForPurchaseLaterRequest;
import com.paypal.hybris.data.PayPalSetupTokenResponse;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.AdapterException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPaypalCreatePaymentTokenCommandTest {
    private static final String API_URL = "https://api-m.sandbox.paypal.com/v3/vault/payment-tokens";
    private static final String TEST_RESPONSE_ID = "testResponseId";

    @InjectMocks
    @Spy
    private DefaultPaypalCreatePaymentTokenCommand unit;
    @Mock
    private RestTemplate restTemplate;
    private PayPalSavePaymentForPurchaseLaterRequest request;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        PayPalAbstractCommandTest.mockCreatePayPalEnvironmentMethodToReturnSandboxEnv(unit);
        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);

        request = new PayPalSavePaymentForPurchaseLaterRequest();
        request.setCustomer(new PayPalCustomerData());
        request.setPaymentSource(new PayPalPaymentSource());
    }

    @Test(expected = HttpClientErrorException.class)
    public void shouldRethrowHttpClientErrorExceptionWhenOccurs() {
        when(restTemplate.postForEntity(eq(API_URL), any(HttpEntity.class), eq(PayPalSetupTokenResponse.class)))
                .thenThrow(HttpClientErrorException.class);

        unit.perform(request);
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterExceptionWhenRestClientThrowsNonHttpClientErrorException() {
        when(restTemplate.postForEntity(eq(API_URL), any(HttpEntity.class), eq(PayPalSetupTokenResponse.class)))
                .thenThrow(RuntimeException.class);

        unit.perform(request);
    }

    @Test
    public void shouldReturnResponseBodyWhenExceptionDoesNotOccur() {
        PayPalSetupTokenResponse payPalSetupTokenResponse = new PayPalSetupTokenResponse();
        payPalSetupTokenResponse.setId(TEST_RESPONSE_ID);

        when(restTemplate.postForEntity(eq(API_URL), any(HttpEntity.class), eq(PayPalSetupTokenResponse.class)))
                .thenReturn(new ResponseEntity<>(payPalSetupTokenResponse, HttpStatus.OK));

        PayPalSetupTokenResponse result = unit.perform(request);
        assertEquals(TEST_RESPONSE_ID, result.getId());
    }

}
