package com.paypal.hybris.core.commands.impl;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.commands.request.StandaloneRefundRequest;
import de.hybris.platform.payment.dto.BillingInfo;
import de.hybris.platform.payment.dto.CardInfo;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.math.BigDecimal;
import java.util.Currency;

import static org.junit.Assert.assertNull;

@UnitTest
public class DefaultPayPalStandaloneRefundCommandTest {

    private static final String MERCHANT_TRANSACTION_CODE = "merchantTransactionCode";
    private static final String USD = "USD";
    private static final String AMOUNT = "123.45";
    @InjectMocks
    @Spy
    private DefaultPayPalStandaloneRefundCommand unit;

    private StandaloneRefundRequest request;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        request = new StandaloneRefundRequest(
                MERCHANT_TRANSACTION_CODE,
                new BillingInfo(),
                new CardInfo(),
                Currency.getInstance(USD),
                new BigDecimal(AMOUNT));
    }

    @Test
    public void shouldReturnNullWhenRefundRequestIsNonNull() {
        assertNull(unit.perform(request));
    }

    @Test
    public void shouldReturnNullWhenRefundRequestIsNull() {
        assertNull(unit.perform(null));
    }

    @Test
    public void shouldReturnNullWhenPassingRefundRequestAsObject() {
        assertNull(unit.perform(((Object) request)));
    }

    @Test
    public void shouldReturnNullWhenPassingRefundRequestAsNullObject() {
        assertNull(unit.perform(((Object) null)));
    }

}
