package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import com.paypal.hybris.data.OrderItemData;
import com.paypal.hybris.data.PayPalOrderResponseData;
import com.paypal.hybris.data.PayPalTrackingInfoData;
import com.paypal.hybris.data.PayPalTrackingInfoRequestData;
import com.paypal.hybris.data.SimpleAmount;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.AdapterException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalSendTrackingInfoCommandTest {

    private static final String ORDER_ID = "orderId";
    private static final int QUANTITY = 3;
    private static final String PRODUCT_NAME = "productName";
    private static final String SKU = "productSku";
    private static final String VALUE = "123.45";
    private static final String USD = "USD";
    private static final String CARRIER = "carrier";
    private static final String CAPTURE_ID = "captureId";
    private static final String TRACKING_NUMBER = "trackingNumber";
    private static final String COMPLETED = "COMPLETED";
    private AutoCloseable closeable;
    private OrderItemData orderItemData;
    private PayPalTrackingInfoData payPalTrackingInfoData;
    private PayPalTrackingInfoRequestData trackingInfoRequestData;
    private PayPalOrderResponseData responseData;
    private SimpleAmount simpleAmount;
    private ResponseEntity<PayPalOrderResponseData> response;

    @Mock
    private RestTemplate restTemplate;

    @Spy
    @InjectMocks
    private DefaultPayPalSendTrackingInfoCommand unit;

    @Before
    public void setUp() throws Exception {
        closeable = MockitoAnnotations.openMocks(this);

        PayPalAbstractCommandTest.mockCreatePayPalEnvironmentMethodToReturnSandboxEnv(unit);
        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);

        orderItemData = new OrderItemData();
        payPalTrackingInfoData = new PayPalTrackingInfoData();
        trackingInfoRequestData = new PayPalTrackingInfoRequestData();
        simpleAmount = new SimpleAmount();
        responseData = new PayPalOrderResponseData();

        simpleAmount.setValue(VALUE);
        simpleAmount.setCurrencyCode(USD);

        payPalTrackingInfoData.setOrderId(ORDER_ID);
        payPalTrackingInfoData.setTrackingInfo(trackingInfoRequestData);

        orderItemData.setSku(SKU);
        orderItemData.setName(PRODUCT_NAME);
        orderItemData.setAmount(simpleAmount);
        orderItemData.setQuantity(QUANTITY);

        trackingInfoRequestData.setCaptureId(CAPTURE_ID);
        trackingInfoRequestData.setCarrier(CARRIER);
        trackingInfoRequestData.setTrackingNumber(TRACKING_NUMBER);
        trackingInfoRequestData.setItems(List.of(orderItemData));

        response = new ResponseEntity<>(responseData, HttpStatus.CREATED);
        responseData.setStatus(COMPLETED);
    }

    @After
    public void tearDown() throws Exception {
        closeable.close();
    }

    @Test
    public void shouldReturnCompletedResponse() {
        when(restTemplate.postForEntity(any(String.class), any(), eq(PayPalOrderResponseData.class)))
                .thenReturn(response);

        String performResult = unit.perform(payPalTrackingInfoData);

        assertEquals(COMPLETED, performResult);
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterExceptionWhenAnyExceptionOccursInRestTemplate() {
        when(restTemplate.postForEntity(any(String.class), any(), eq(PayPalOrderResponseData.class)))
                .thenThrow(RuntimeException.class);

        unit.perform(payPalTrackingInfoData);
    }

}
