package com.paypal.hybris.core.commands.impl;

import com.paypal.api.payments.Event;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.AdapterException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockedStatic;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mockStatic;

@UnitTest
public class DefaultPayPalGetEventCommandTest {
    private static final String TEST_EVENT_ID = "testEventId";
    @InjectMocks
    @Spy
    private DefaultPayPalGetEventCommand unit;
    private Event event;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        event = new Event();
        event.setId(TEST_EVENT_ID);

        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);
    }

    @Test
    public void shouldReturnEventForEventId() {
        try (MockedStatic<Event> eventMockedStatic = mockStatic(Event.class)){

            eventMockedStatic.when(() -> Event.get(any(APIContext.class), eq(TEST_EVENT_ID))).thenReturn(event);

            Event result = unit.perform(TEST_EVENT_ID);

            eventMockedStatic.verify(() -> Event.get(any(APIContext.class), eq(TEST_EVENT_ID)));
            assertEquals(event, result);
        }
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterExceptionWhenPayPalRESTExceptionOccurs() {
        try (MockedStatic<Event> eventMockedStatic = mockStatic(Event.class)){
            eventMockedStatic.when(() -> Event.get(any(APIContext.class), eq(TEST_EVENT_ID)))
                    .thenThrow(PayPalRESTException.class);

            unit.perform(TEST_EVENT_ID);
        }
    }

}
