package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import javax.ws.rs.core.Response;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalDeletePaymentTokenCommandTest {
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    private static final String API_URL = "https://api-m.sandbox.paypal.com/v3/vault/payment-tokens/" + SUBSCRIPTION_ID;

    @InjectMocks
    @Spy
    private DefaultPayPalDeletePaymentTokenCommand unit;
    @Mock
    private RestTemplate restTemplate;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        PayPalAbstractCommandTest.mockCreatePayPalEnvironmentMethodToReturnSandboxEnv(unit);
        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);
    }

    @Test
    public void shouldReturnTrueWhenResponseHas204Status() {
        ResponseEntity<Response> response = new ResponseEntity<>(HttpStatus.NO_CONTENT);
        when(restTemplate.exchange(eq(API_URL), eq(HttpMethod.DELETE), any(HttpEntity.class), eq(Response.class)))
                .thenReturn(response);

        assertTrue(unit.perform(SUBSCRIPTION_ID));
    }

    @Test
    public void shouldReturnFalseWhenResponseHasNon204Status() {
        ResponseEntity<Response> response = new ResponseEntity<>(HttpStatus.OK);
        when(restTemplate.exchange(eq(API_URL), eq(HttpMethod.DELETE), any(HttpEntity.class), eq(Response.class)))
                .thenReturn(response);

        assertFalse(unit.perform(SUBSCRIPTION_ID));
    }

    @Test
    public void shouldReturnFalseWhenRestTemplateThrowsAnyException() {
        when(restTemplate.exchange(eq(API_URL), eq(HttpMethod.DELETE), any(HttpEntity.class), eq(Response.class)))
                .thenThrow(RuntimeException.class);

        assertFalse(unit.perform(SUBSCRIPTION_ID));
    }

}
