package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import com.paypal.hybris.data.PayPalConvertBAToPaymentTokensRequestData;
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData;
import com.paypal.hybris.data.PayPalTokenData;
import com.paypal.hybris.data.PaymentSourceData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.AdapterException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import java.util.Optional;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalConvertBAToPaymentTokensCommandTest {

    private static final String ID = "id";
    private static final String BILLING_AGREEMENT = "BILLING_AGREEMENT";

    @Mock
    private RestTemplate restTemplate;

    @Spy
    @InjectMocks
    private DefaultPayPalConvertBAToPaymentTokensCommand unit;

    private PayPalConvertBAToPaymentTokensRequestData request;

    private PaymentSourceData paymentSource;

    private PayPalTokenData payPalTokenData;
    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        PayPalAbstractCommandTest.mockCreatePayPalEnvironmentMethodToReturnSandboxEnv(unit);
        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);

        request = new PayPalConvertBAToPaymentTokensRequestData();
        paymentSource = new PaymentSourceData();
        payPalTokenData = new PayPalTokenData();

        payPalTokenData.setId(ID);
        payPalTokenData.setType(BILLING_AGREEMENT);
        paymentSource.setToken(payPalTokenData);
        request.setPaymentSource(paymentSource);
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterException() {
        PayPalGetCardDetailsResponseData payPalGetCardDetailsResponseData = new PayPalGetCardDetailsResponseData();
        payPalGetCardDetailsResponseData.setId(ID);;

        when(restTemplate.postForEntity(any(String.class), any(HttpEntity.class), eq(PayPalGetCardDetailsResponseData.class)))
                .thenThrow(HttpClientErrorException.class);

        unit.perform(request);
    }

    @Test
    public void shouldConvertToken() {
        PayPalGetCardDetailsResponseData payPalGetCardDetailsResponseData = new PayPalGetCardDetailsResponseData();
        payPalGetCardDetailsResponseData.setId(ID);;

        when(restTemplate.postForEntity(any(String.class), any(HttpEntity.class), eq(PayPalGetCardDetailsResponseData.class)))
                .thenReturn(new ResponseEntity<>(payPalGetCardDetailsResponseData, HttpStatus.OK));

        Optional<PayPalGetCardDetailsResponseData> result = unit.perform(request);

        assertTrue(result.isPresent());
        assertEquals(ID, result.get().getId());
    }
}