package com.paypal.hybris.core.commands.impl;

import com.paypal.hybris.core.commands.PayPalAbstractCommandTest;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.data.PayPalConnectUserData;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.payment.AdapterException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalConnectGetUserInformationCommandTest {
    private static final String API_URL = "https://api-m.sandbox.paypal.com/";
    private static final String USER_INFO_ENDPOINT_URL = API_URL + "identity/oauth2/userinfo?schema=paypalv1.1";

    private static final String TEST_USER_NAME = "testUserName";
    private static final String ACCESS_TOKEN = "accessToken";

    @InjectMocks
    @Spy
    private DefaultPayPalConnectGetUserInformationCommand unit;
    @Mock
    private RestTemplate restTemplate;
    @Mock
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        PayPalAbstractCommandTest.mockCreatePayPalEnvironmentMethodToReturnSandboxEnv(unit);
        PayPalAbstractCommandTest.mockCreateApiContextMethodToReturnSandboxApiContext(unit);

        when(defaultPayPalConfigurationService.getPayPalApiUrl()).thenReturn(API_URL);
    }

    @Test(expected = AdapterException.class)
    public void shouldThrowAdapterExceptionWhenRestClientThrowsAnyException() {
        when(restTemplate.exchange(eq(USER_INFO_ENDPOINT_URL), eq(HttpMethod.GET), any(HttpEntity.class), eq(PayPalConnectUserData.class)))
                .thenThrow(RuntimeException.class);

        unit.perform(ACCESS_TOKEN);
    }

    @Test
    public void shouldReturnPayPalConnectUserDataWhenExceptionDoesNotOccur() {
        PayPalConnectUserData payPalConnectUserData = new PayPalConnectUserData();
        payPalConnectUserData.setName(TEST_USER_NAME);

        when(restTemplate.exchange(eq(USER_INFO_ENDPOINT_URL), eq(HttpMethod.GET), any(HttpEntity.class), eq(PayPalConnectUserData.class)))
                .thenReturn(new ResponseEntity<>(payPalConnectUserData, HttpStatus.OK));

        PayPalConnectUserData result = unit.perform(ACCESS_TOKEN);

        assertEquals(TEST_USER_NAME, result.getName());
    }

}
