package com.paypal.hybris.core.auth;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Assert;
import org.junit.Test;

@UnitTest
public class ConnectWithPayPalAuthenticationTokenTest {

    @Test
    public void shouldCreateConnectWithPayPalAuthenticationToken() {
        String expectedPrincipal = "principal";
        ConnectWithPayPalAuthenticationToken result = new ConnectWithPayPalAuthenticationToken(expectedPrincipal);
        Assert.assertEquals(expectedPrincipal, result.getPrincipal());
    }

    @Test(expected = IllegalArgumentException.class)
    public void shouldThrowIllegalArgumentExceptionDuringCreatingConnectWithPayPalAuthenticationToken() {
        ConnectWithPayPalAuthenticationToken result = new ConnectWithPayPalAuthenticationToken(null);
    }
}