package com.paypal.hybris.core.attributehandlers;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.media.MediaFolderModel;
import de.hybris.platform.core.model.media.MediaModel;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.when;

@UnitTest
@RunWith(MockitoJUnitRunner.StrictStubs.class)
public class DefaultPayPalPrettyImgUrlHandlerTest {

    private static final String FOLDER_QUALIFIER = "folder/qualifier";
    private static final String FILE_NAME = "fileName.jpg";
    private static final String LOCATION = "source/location/fileName.jpg";
    private static final String LOCATION_WITHOUT_FILE = "source/location/";
    private static final String TENANT = "tenant";
    private static final String EXPECTED_PRETTY_PATH= "/medias/sys_tenant/folder/qualifier/source/location/fileName/fileName.jpg";

    @Mock
    private MediaModel mediaModel;
    @Mock
    private MediaFolderModel mediaFolderModel;

    @Spy
    @InjectMocks
    private DefaultPayPalPrettyImgUrlHandler unit;

    @Before
    public void setup() {
        doReturn(TENANT).when(unit).getTenantId();
        when(mediaModel.getFolder()).thenReturn(mediaFolderModel);
        when(mediaFolderModel.getQualifier()).thenReturn(FOLDER_QUALIFIER);
        when(mediaModel.getRealFileName()).thenReturn(FILE_NAME);
    }

    @Test
    public void shouldReturnPrettyUrlWhenFileLocationExists() {
        when(mediaModel.getLocation()).thenReturn(LOCATION);

        String result = unit.get(mediaModel);

        assertThat(result).isEqualTo(EXPECTED_PRETTY_PATH);
    }

    @Test
    public void shouldReturnEmptyStringWhenFileLocationIsWithoutFile(){
        when(mediaModel.getLocation()).thenReturn(LOCATION_WITHOUT_FILE);

        String result = unit.get(mediaModel);

        assertThat(result).isEqualTo(StringUtils.EMPTY);
    }

}
