package com.paypal.hybris.core;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.Registry;
import de.hybris.platform.jalo.JaloSession;
import de.hybris.platform.jalo.user.User;
import de.hybris.platform.util.RedeployUtilities;
import de.hybris.platform.util.Utilities;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.MockedStatic;

import static org.mockito.Mockito.when;
import static org.mockito.Mockito.mockStatic;

@UnitTest
public class PaypalcoreStandaloneTest {

    private static final String SESSION_ID = "sessionID";

    @Mock
    private JaloSession jaloSession;

    @Mock
    private User user;

    @InjectMocks
    private PaypalcoreStandalone unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }
    @Test
    public void shouldRun() {
        try (MockedStatic<JaloSession> jaloSessionMockedStatic = mockStatic(JaloSession.class);
             MockedStatic<Registry> registryMockedStatic = mockStatic(Registry.class);
             MockedStatic<Utilities> utilitiesMockedStatic = mockStatic(Utilities.class);
             MockedStatic<RedeployUtilities> redeployUtilitiesMockedStatic = mockStatic(RedeployUtilities.class);
        ){
            jaloSessionMockedStatic.when(JaloSession::getCurrentSession).thenReturn(jaloSession);

            when(jaloSession.getSessionID()).thenReturn(SESSION_ID);
            when(jaloSession.getUser()).thenReturn(user);


            PaypalcoreStandalone.main(new String[1]);

            registryMockedStatic.verify(Registry::activateStandaloneMode);
            registryMockedStatic.verify(Registry::activateMasterTenant);
            utilitiesMockedStatic.verify(Utilities::printAppInfo);
            redeployUtilitiesMockedStatic.verify(RedeployUtilities::shutdown);
        }
    }

}
