package com.paypal.hybris.core.util;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class ExpiredDateValidatorUtil {

    private static final String MONTH_YEAR_STRING_FORMAT = "%s/%s";
    private static final String MONTH_YEAR_FORMAT = "MM/yyyy";

    public long getMonthsToExpiration(String month, String year) {
        String expiryDateInStr = String.format(MONTH_YEAR_STRING_FORMAT, month, year);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(MONTH_YEAR_FORMAT);
        YearMonth expiryDate = YearMonth.parse(expiryDateInStr, formatter);
        return ChronoUnit.MONTHS.between(YearMonth.now(), expiryDate);
    }

}
