package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.REPLENISHMENT;

public class ReplenishmentStoredCredentialStrategy implements StoredCredentialStrategy {

    private PayPalConfigurationService payPalConfigurationService;

    @Override
    public StoredCredentialData getStoredCredential() {
        return GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, MERCHANT)
                .with(StoredCredentialData::setPaymentType, RECURRING)
                .with(StoredCredentialData::setUsage, SUBSEQUENT)
                .build();
    }

    @Override
    public boolean test(String flow) {
        return flow.equalsIgnoreCase(REPLENISHMENT)
                && !payPalConfigurationService.getPayPal3DSVerificationType().equalsIgnoreCase(DISABLE);
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }
}
