package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.ONE_TIME_PAYMENT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;

public class IntentCaptureOneTimePaymentStrategy implements StoredCredentialStrategy {

    private PayPalConfigurationService payPalConfigurationService;

    @Override
    public StoredCredentialData getStoredCredential() {
        return GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, CUSTOMER)
                .with(StoredCredentialData::setPaymentType, ONE_TIME)
                .with(StoredCredentialData::setUsage, DERIVED)
                .build();
    }


    @Override
    public boolean test(String flow) {
        return payPalConfigurationService.getPayPalIntent().equalsIgnoreCase(PAYPAL_INTENT_CAPTURE)
                && flow.equalsIgnoreCase(ONE_TIME_PAYMENT)
                && !payPalConfigurationService.getPayPal3DSVerificationType().equalsIgnoreCase(DISABLE);
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }
}
