package com.paypal.hybris.core.strategy.storedcredential.impl;

import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.strategy.storedcredential.StoredCredentialStrategy;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.StoredCredentialData;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.SAVED_PAYMENT;

public class IntentAuthorizeSavedPaymentStrategy implements StoredCredentialStrategy {

    private PayPalConfigurationService payPalConfigurationService;

    @Override
    public StoredCredentialData getStoredCredential() {
        return GenericBuilder.of(StoredCredentialData::new)
                .with(StoredCredentialData::setPaymentInitiator, CUSTOMER)
                .with(StoredCredentialData::setPaymentType, UNSCHEDULED)
                .with(StoredCredentialData::setUsage, SUBSEQUENT)
                .build();
    }


    @Override
    public boolean test(String flow) {
        return payPalConfigurationService.getPayPalIntent().equalsIgnoreCase(PAYPAL_INTENT_AUTHORIZE)
                && flow.equalsIgnoreCase(SAVED_PAYMENT)
                && !payPalConfigurationService.getPayPal3DSVerificationType().equalsIgnoreCase(DISABLE);
    }

    public void setPayPalConfigurationService(PayPalConfigurationService payPalConfigurationService) {
        this.payPalConfigurationService = payPalConfigurationService;
    }
}
