/**
 *
 */
package com.paypal.hybris.core.strategy.impl;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.strategy.PayPalCommercePaymentProviderStrategy;
import de.hybris.platform.commerceservices.order.impl.DefaultCommercePaymentProviderStrategy;
import de.hybris.platform.core.model.order.AbstractOrderModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.order.CartService;
import org.springframework.beans.factory.annotation.Required;

import java.util.Optional;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PROVIDER_NAME;


public class DefaultPayPalCommercePaymentProviderStrategy extends DefaultCommercePaymentProviderStrategy
    implements PayPalCommercePaymentProviderStrategy {

    private CartService cartService;

    @Override
    public String getPaymentProvider() {
        String paymentProvider;

        Optional<PaymentInfoModel> paymentInfoModel = Optional.ofNullable(cartService.getSessionCart())
            .map(AbstractOrderModel::getPaymentInfo);

        if (!paymentInfoModel.isPresent() || paymentInfoModel.get() instanceof PayPalCreditCardPaymentInfoModel) {
            paymentProvider = PAYPAL_PROVIDER_NAME;
        } else {
            paymentProvider = super.getPaymentProvider();
        }

        return paymentProvider;
    }

 public String getPaymentProvider(final CartModel cart) {

        String paymentProvider;

        if (cart.getPaymentInfo() instanceof PayPalCreditCardPaymentInfoModel) {
            paymentProvider = PAYPAL_PROVIDER_NAME;
        } else {
            paymentProvider = super.getPaymentProvider();
        }

        return paymentProvider;
    }

    @Required
    public void setCartService(CartService cartService) {
        this.cartService = cartService;
    }
}
