package com.paypal.hybris.core.strategy.impl;

import com.paypal.hybris.core.enums.PaymentStatusType;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalPaymentService;
import de.hybris.platform.commerceservices.order.impl.DefaultCommercePaymentAuthorizationStrategy;
import de.hybris.platform.commerceservices.service.data.CommerceCheckoutParameter;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;
import org.apache.commons.lang.StringUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Currency;


public class DefaultPayPalCommercePaymentAuthorizationStrategy extends DefaultCommercePaymentAuthorizationStrategy {

    private PayPalPaymentService payPalPaymentService;
    @Override
    public PaymentTransactionEntryModel authorizePaymentAmount(final CommerceCheckoutParameter parameter) {
        final CartModel cartModel = parameter.getCart();
        final BigDecimal amount = parameter.getAuthorizationAmount();
        final String paymentProvider = parameter.getPaymentProvider();

        PaymentTransactionEntryModel transactionEntryModel = null;
        try {
            beforeAuthorizePaymentAmount(parameter);
            final PaymentInfoModel paymentInfo = cartModel.getPaymentInfo();
            if (paymentInfo instanceof PayPalCreditCardPaymentInfoModel
                && StringUtils.isNotBlank(((PayPalCreditCardPaymentInfoModel) paymentInfo).getPayPalOrderId())) {
                final Currency currency = getI18nService()
                    .getBestMatchingJavaCurrency(cartModel.getCurrency().getIsocode());
                final String merchantTransactionCode = getGenerateMerchantTransactionCodeStrategy()
                    .generateCode(cartModel);
                transactionEntryModel = getPayPalPaymentService().authorizePayment(merchantTransactionCode, amount,
                    currency, cartModel, paymentProvider);
                if (transactionEntryModel != null) {
                    final PaymentTransactionModel paymentTransaction = transactionEntryModel.getPaymentTransaction();

                    if (TransactionStatus.ACCEPTED.name().equals(transactionEntryModel.getTransactionStatus())
                        || TransactionStatus.REVIEW.name().equals(transactionEntryModel.getTransactionStatus())) {
                        cartModel.setPaymentStatusType(PaymentStatusType.PENDING);
                        paymentTransaction.setOrder(cartModel);
                        paymentTransaction.setInfo(paymentInfo);
                        getModelService().saveAll(cartModel, paymentTransaction);
                    }
                }
            }
            return transactionEntryModel;
        } finally {
            afterAuthorizePaymentAmount(parameter, transactionEntryModel);
        }
    }

    public PayPalPaymentService getPayPalPaymentService() {
        return payPalPaymentService;
    }

    public void setPayPalPaymentService(PayPalPaymentService payPalPaymentService) {
        this.payPalPaymentService = payPalPaymentService;
    }

}
