package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PaypalAccessTokenDao;
import com.paypal.hybris.core.service.PaypalAccessTokenService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.core.model.PaypalAccessTokenModel;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;
import de.hybris.platform.servicelayer.model.ModelService;

import java.util.Optional;

public class DefaultPaypalAccessTokenService implements PaypalAccessTokenService {

    private PaypalAccessTokenDao paypalAccessTokenDao;

    private GuidKeyGenerator guidKeyGenerator;

    private ModelService modelService;

    public Optional<PaypalAccessTokenModel> getPaypalAccessToken(String guid) {
        return paypalAccessTokenDao.findAccessTokenByGuid(guid);
    }

    public String savePaypalAccessToken(String accessToken) {
        String guid = guidKeyGenerator.generate().toString();

        PaypalAccessTokenModel paypalAccessToken = GenericBuilder.of(PaypalAccessTokenModel::new)
                .with(PaypalAccessTokenModel::setAccessToken, accessToken)
                .with(PaypalAccessTokenModel::setGuid, guid)
                .build();
        modelService.save(paypalAccessToken);

        return guid;
    }

    public void removePaypalAccessToken(String accessTokenGuid) {
        getPaypalAccessToken(accessTokenGuid).ifPresent(accessToken -> modelService.remove(accessToken));
    }

    public void setPaypalAccessTokenDao(PaypalAccessTokenDao paypalAccessTokenDao) {
        this.paypalAccessTokenDao = paypalAccessTokenDao;
    }

    public void setGuidKeyGenerator(GuidKeyGenerator guidKeyGenerator) {
        this.guidKeyGenerator = guidKeyGenerator;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

}
