/*

 */
package com.paypal.hybris.core.service.impl;

import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.commerceservices.event.RegisterEvent;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.servicelayer.user.UserService;

/**
 * This class extends DefaultCustomerAccountService and override register method
 */
public class DefaultPayPalConnectCustomerAccountService extends DefaultPayPalCustomerAccountService {

    private UserService userService;

    @Override
    public void register(final CustomerModel customerModel, final String password) throws DuplicateUidException {
        if (!userService.isUserExisting(customerModel.getUid())) {
            registerCustomer(customerModel, password);
            getEventService().publishEvent(initializeEvent(new RegisterEvent(), customerModel));
        } else {
            throw new DuplicateUidException(customerModel.getContactEmail());
        }
    }

    @Override
    public UserService getUserService() {
        return userService;
    }

    @Override
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}
