/*

 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.enums.ThreeDsVerificationType;
import com.paypal.hybris.core.exception.PayPalPluginConfigurationNotFound;
import com.paypal.hybris.core.model.HostedFieldsConfigurationModel;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import de.hybris.platform.store.BaseStoreModel;
import de.hybris.platform.store.services.BaseStoreService;

import java.util.Optional;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.CLIENT_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_API_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_CHECKOUT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RESPONSE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_RETURN_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCOPES;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CONNECT_SCRIPT;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ENV_CONFIGURATION;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_AUTHORIZE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_INTENT_CAPTURE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_NONDECIMAL_CURRENCY;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_PARTNER_ATTRIBUTION_ID;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_SDK_JS_URL;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.SECRET_KEY;

/**
 * This class is a default implementation of the PayPalConfigurationService interface
 */
public class DefaultPayPalConfigurationService implements PayPalConfigurationService {

    private ConfigurationService configurationService;

    private BaseStoreService baseStoreService;

    @Override
    public boolean isExpressCheckoutEnabled() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isExpressCheckoutEnable();
    }

    @Override
    public boolean isVenmoEnabled() {
        return getPayPalPluginConfiguration().getVenmoConfiguration().isEnable();
    }

    @Override
    public boolean isPayLaterEnabledForNonUsCountries() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isPayLaterForNonUsCountries();
    }

    @Override
    public boolean isCommitEnabled() {
        return getPayPalIntent().equalsIgnoreCase(PAYPAL_INTENT_CAPTURE);
    }

    @Override
    public boolean isReplenishmentAvailable() {
        PayPalPluginConfigurationModel payPalPluginConfiguration = getPayPalPluginConfiguration();
        PayPalConfigurationModel payPalConfig = payPalPluginConfiguration.getPayPalConfiguration();
        HostedFieldsConfigurationModel hostedFieldsConfig = payPalPluginConfiguration.getHostedFieldsConfiguration();

        return payPalConfig.isPayPalEnable() && payPalConfig.isVaultEnabled()
                || hostedFieldsConfig.isEnable() && hostedFieldsConfig.isVaultFlow();
    }

    @Override
    public String getClientID() {
        return configurationService.getConfiguration().getString(CLIENT_ID);
    }

    @Override
    public String getPayPalPartnerAttributionId() {
        return configurationService.getConfiguration().getString(PAYPAL_PARTNER_ATTRIBUTION_ID);
    }

    @Override
    public int getPayPalExpireBetween() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().getExpireBetween();
    }

    @Override
    public boolean isPayPalCreditCardOnAddingValidation() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().isExpireOnAdding();
    }

    @Override
    public boolean isPayPalConnectAddPaymentMethodFlow() {
        return getPayPalPluginConfiguration().getConnectWithPayPalConfiguration().isAddPaymentMethodFlow();
    }

    @Override
    public boolean isApplePayEnable() {
        return getPayPalPluginConfiguration().getApplePayConfiguration().isEnable();
    }

    @Override
    public boolean isL2L3DataEnabled() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().isL2L3Data();
    }

    @Override
    public boolean isApplePayOnExpressCheckoutEnable() {
        return getPayPalPluginConfiguration().getApplePayConfiguration().isExpressCheckoutEnable();
    }

    @Override
    public boolean isPayPalEnable() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isPayPalEnable();
    }

    @Override
    public boolean isPayPalSaveOrderFlowEnabled() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isSaveOrderFlow();
    }

    @Override
    public boolean isPayPalHostedFieldsVaultEnabled() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().isVaultFlow();
    }

    @Override
    public String getPayPalVerifyCCOnMyAccount() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().getVerificationOnMyAccount().getCode();
    }

    @Override
    public boolean isPayPalAdditionalSecurityEnabled() {
        return getPayPalPluginConfiguration().getConnectWithPayPalConfiguration().isAdditionalSecurity();
    }

    @Override
    public boolean isPayPalHostedFieldsEnabled() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().isEnable();
    }

    @Override
    public boolean isFraudNetEnabled() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().isFraudNetIntegration();
    }

    @Override
    public boolean isFraudNetSandboxEnabled() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().isFraudNetSandbox();
    }

    @Override
    public String getFraudNetId(String pageType) {
        return getConfigurationService().getConfiguration().getString("paypal.fraudnet." + pageType + ".id");
    }

    @Override
    public String getSecretKey() {
        return getConfigurationService().getConfiguration().getString(SECRET_KEY);
    }

    @Override
    public String getEnvironmentType() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_ENV_CONFIGURATION);
    }

    @Override
    public String getPayPalApiUrl() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_API_URL);
    }

    @Override
    public String getPayPalSdkJsUrl() {
        return getConfigurationService().getConfiguration().getString(PAYPAL_SDK_JS_URL);
    }

    @Override
    public String getPayPalIntent() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().isSettleImmediately()
                ? PAYPAL_INTENT_CAPTURE : PAYPAL_INTENT_AUTHORIZE;
    }

    @Override
    public String getPayPalIntent(BaseStoreModel baseStore) {
        return baseStore.getPayPalPluginConfiguration().getPayPalGeneralConfiguration().isSettleImmediately()
                ? PAYPAL_INTENT_CAPTURE : PAYPAL_INTENT_AUTHORIZE;
    }

    @Override
    public boolean isConnectWithPayPalIsEnable(){
        return getPayPalPluginConfiguration().getConnectWithPayPalConfiguration().isEnable();
    }

    @Override
    public String getPayPal3DSVerificationType() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().getThreeDsVerificationOnCheckout().getCode();
    }

    @Override
    public String getNonDecimalCurrency() {
        return configurationService.getConfiguration().getString(PAYPAL_NONDECIMAL_CURRENCY);
    }

    @Override
    public String getPayPalConnectScript() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCRIPT);
    }

    @Override
    public String getPayPalConnectScopes() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_SCOPES);
    }

    @Override
    public String getPayPalConnectResponseType() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_RESPONSE_TYPE);
    }

    @Override
    public String getPayPalConnectReturnUrl() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_RETURN_URL);
    }

    @Override
    public String getPayPalConnectCheckoutReturnUrl() {
        return configurationService.getConfiguration().getString(PAYPAL_CONNECT_CHECKOUT_RETURN_URL);
    }

    @Override
    public boolean isEnableLoginViaPayPalToTheExistingUser() {
        return getPayPalPluginConfiguration().getConnectWithPayPalConfiguration().isLinkUserAccount();
    }

    @Override
    public String getBuyerCountry() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().getBuyerCountry();
    }

    @Override
    public String getLocale() {
        return getPayPalPluginConfiguration().getPayPalGeneralConfiguration().getLocale();
    }

    @Override
    public boolean isSaveOrderFlow() {
        return isPayPalSaveOrderFlowEnabled() && getPayPalIntent().equals(PAYPAL_INTENT_AUTHORIZE)
                && !isPayPalVaultEnabled();
    }

    @Override
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }


    @Override
    public PayPalPluginConfigurationModel getPayPalPluginConfiguration() {
        return Optional.ofNullable(baseStoreService.getCurrentBaseStore().getPayPalPluginConfiguration()).orElseThrow(
                () -> new PayPalPluginConfigurationNotFound("PayPalPluginConfiguration not found"));
    }

    @Override
    public boolean isLocalPaymentsEnable() {
        return getPayPalPluginConfiguration().getLocalPaymentsConfiguration().isEnable();
    }

    @Override
    public boolean isThreeDsVerificationOnCheckoutEnable() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration()
                .getThreeDsVerificationOnCheckout() != ThreeDsVerificationType.DISABLE;
    }

    @Override
    public boolean isPayPalVaultEnabled() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isVaultEnabled();
    }

    @Override
    public boolean isPayPalVaultFlowEnabled() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isPayPalEnable()
                && getPayPalPluginConfiguration().getPayPalConfiguration().isVaultEnabled();
    }

    @Override
    public boolean isChangePaymentButtonEnabled() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().isChangePaymentButtonEnabled();
    }

    @Override
    public SavedPaymentMethodsLimit getSavedCreditCardsLimit() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration().getSavedCreditCardsLimit();
    }

    @Override
    public SavedPaymentMethodsLimit getSavedPayPalAccountsLimit() {
        return getPayPalPluginConfiguration().getPayPalConfiguration().getSavedPayPalAccountsLimit();
    }

    @Override
    public boolean isThreeDsVerificationOnCheckoutAlwaysRequiredEnable() {
        return getPayPalPluginConfiguration().getHostedFieldsConfiguration()
                .getThreeDsVerificationOnCheckout() == ThreeDsVerificationType.ALWAYS;
    }

    public ConfigurationService getConfigurationService() {
        return configurationService;
    }

    public void setBaseStoreService(BaseStoreService baseStoreService) {
        this.baseStoreService = baseStoreService;
    }
}
