/*

 */
package com.paypal.hybris.core.service.impl;

import com.paypal.hybris.core.dao.PayPalCartDao;
import com.paypal.hybris.core.service.PayPalCartService;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.impl.DefaultCartService;
import javax.annotation.Resource;
import java.util.Optional;

/**
 * This class is a default implementation of the PayPalCartService interface
 */
public class DefaultPayPalCartService extends DefaultCartService implements PayPalCartService {

    @Resource(name = "payPalCartDao")
    private PayPalCartDao cartDao;

    @Override
    public Optional<CartModel> getCartByPayPalOrderIdForLocalPayments(String payPalOrderId) {
        return cartDao.getCartByPayPalOrderIdForLocalPayments(payPalOrderId);
    }

    @Override
    public void setPayPalOrderIdForCurrentCart(String payPalOrderId) {
        CartModel cartModel = getSessionCart();
        cartModel.setPayPalOrderId(payPalOrderId);
        getModelService().save(cartModel);
    }

    @Override
    public void saveCorrelationId(String correlationId) {
        CartModel cartModel = getSessionCart();
        cartModel.setPayPalClientMetadataId(correlationId);
        getModelService().save(cartModel);
    }
}
