package com.paypal.hybris.core.service;

import de.hybris.backoffice.PaypalWebhookData;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;

import java.math.BigDecimal;
import java.util.List;


public interface PaymentTransactionsService {

    BigDecimal calculateRefundedAmount(PaymentTransactionEntryModel transaction);

    List<PaymentTransactionEntryModel> getCaptureTransactionEntries(OrderModel orderModel);

    List<PaymentTransactionEntryModel> getTransactionsToRefund(OrderModel orderModel);

    PaymentTransactionEntryModel getTransactionEntryById(final String transactionId);

    void doOnVoidPerformed(PaypalWebhookData paypalWebhookData);

    void doOnCapturePerformed(PaypalWebhookData paypalWebhookData);

    void doOnRefundPerformed(PaypalWebhookData paypalWebhookData, String captureId);

}
