package com.paypal.hybris.core.service;

import com.paypal.api.payments.Event;
import com.paypal.hybris.core.enums.PaymentProvider;
import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.data.CardData;
import com.paypal.hybris.data.PayPalConvertBAToPaymentTokensRequestData;
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData;
import com.paypal.hybris.data.PayPalOrderDetailsData;
import com.paypal.hybris.data.PayPalOrderRequestData;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.payment.PaymentService;
import de.hybris.platform.payment.commands.request.CaptureRequest;
import de.hybris.platform.payment.commands.request.SubscriptionAuthorizationRequest;
import de.hybris.platform.payment.commands.result.AuthorizationResult;
import de.hybris.platform.payment.commands.result.CaptureResult;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.payment.model.PaymentTransactionModel;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.Optional;


public interface PayPalPaymentService extends PaymentService {

    PaymentTransactionEntryModel createStubAuthorize(final String merchantTransactionCode, final BigDecimal amount,
        final Currency currency, final String paymentProvider, PayPalCreditCardPaymentInfoModel paymentInfo);

    AuthorizationResult reauthorize(SubscriptionAuthorizationRequest request);

    void doCancel(OrderModel order);

    void doCancelTransactions(OrderModel order);

    Event getEventById(String eventId);

    Optional<PayPalGetCardDetailsResponseData> convertBillingAgreementTokenToVault(PayPalConvertBAToPaymentTokensRequestData convertBAToPaymentTokensRequestData);

    PayPalOrderDetailsData getOrderDetails(final String payPalOrderId);

    Optional<CardData> getCardData(final String paymentToken);

    Boolean updateOrderAmountDetails(PayPalOrderRequestData orderRequestData);

    String createOrder(PayPalOrderRequestData orderRequestData);

    CaptureResult doCaptureIntentRequest(CaptureRequest request);

    PaymentTransactionEntryModel refund(PaymentTransactionEntryModel selectedEntry, BigDecimal amount);

    boolean savePayPalOrder(PayPalCreditCardPaymentInfoModel paymentInfoModel, CartModel cart);

    PaymentTransactionEntryModel authorizePayment(String merchantTransactionCode, BigDecimal amount, Currency currency,
       CartModel cartModel, String paymentProvider);
    
    void captureVaultedPayment(PaymentTransactionModel transaction, String scaFlow, PaymentProvider payPalPaymentProvider);

    PaymentTransactionEntryModel authorizeVaultedPayment(String merchantTransactionCode, BigDecimal amount, Currency currency,
                                                         CartModel cartModel, String paymentProvider, String scaFlow, PaymentProvider payPalPaymentProvider);
}
