/**
 *
 */
package com.paypal.hybris.core.service;


import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.data.PayPalSavePaymentForPurchaseLaterRequest;
import com.paypal.hybris.data.PayPalSetupTokenResponse;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;

import java.util.Optional;

public interface PayPalPaymentInfoService {

    Optional<PayPalCreditCardPaymentInfoModel> getCreditCardBySubscriptionId(String subscriptionId);

    Optional<PayPalCreditCardPaymentInfoModel> getPaymentInfoByOrderId(String orderId);

    Optional<PayPalCreditCardPaymentInfoModel> getPaymentInfoByPK(String pk);

    void removePaymentInfoByPK(String pk);

    boolean isSavedPayPalAccountsAmountLimited();

    boolean isSavedCreditCardsAmountLimited();

    boolean isChangePaymentButtonActive();

    /**
     * reset Expiration status to creditCardPaymentInfoModel
     */
    void updateExpirationStatus(PayPalCreditCardPaymentInfoModel paymentInfoModel);
    PayPalSetupTokenResponse getPaypalPaymentToken(PayPalSavePaymentForPurchaseLaterRequest payPalSavePaymentRequest);
    boolean deletePaypalPaymentToken(String subscriptionId);
    PayPalSetupTokenResponse getPaypalSetupToken(PayPalSavePaymentForPurchaseLaterRequest payPalSavePaymentRequest);
    boolean isPayPalSaveOrderFlowActive(PaymentInfoModel paymentInfoModel);
}
