package com.paypal.hybris.core.service;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.data.PayPalGetCardDetailsResponseData;
import com.paypal.hybris.data.PayPalSetupTokenResponse;
import com.paypal.hybris.data.SetupTokenRequestData;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.core.model.order.payment.CreditCardPaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;

import java.util.Optional;


public interface PayPalCustomerAccountService {

    PayPalCreditCardPaymentInfoModel createPayPalPaymentSubscription(final CustomerModel customerModel,
        final CCPaymentInfoData ccPaymentInfoData, final AddressModel addressModel, PayPalCreditCardPaymentInfoModel dumbPaymentInfo);

    CreditCardPaymentInfoModel updateStubCreditCardPaymentInfo(PayPalCreditCardPaymentInfoModel paymentInfo, PayPalSetupTokenResponse paymentTokenResponse);

    void updateCreditCardInfo(PayPalGetCardDetailsResponseData payPalGetCardDetails,
                              PayPalCreditCardPaymentInfoModel paymentInfo);

    PayPalCreditCardPaymentInfoModel updatePayPalPaymentSubscription(final CustomerModel customerModel,
        final CCPaymentInfoData ccPaymentInfoData, final AddressModel addressModel,
        PayPalCreditCardPaymentInfoModel paymentInfo);

    /**
     * This method is used to get customer data by payer id
     * @param payerId payer id
     * @return customer data
     */
    CustomerData getCustomerDataByPayerId(final String payerId);

    /**
     * This method checks if Customer Exist
     * @param payerId payerId
     * @return if customer exist
     */
    boolean isCustomerWithPayerIdExist(final String payerId);

    String setTempPassword(final String payerId);

    /**
     * This method clears temp password
     * @param payerId payerId
     */
    void clearTempPassword(final String payerId);

    /**
     * This method is used to get customer model by payer id
     * @param payerId payer id
     * @return customer model
     */
    CustomerModel getCustomerModelByPayerId(final String payerId);

    void setAccessTokenForCustomer(final String accessTokenGuid, final String payerId);

    void setDefaultAccessToken(String payerId);

    CustomerData getCustomerDataByUid(final String uId);

    Optional<CustomerModel> getCustomerByVaultId(String vaultId);

    PayPalCreditCardPaymentInfoModel createStubCreditCardPaymentInfo(SetupTokenRequestData tokenRequestData,
                                                                     CustomerModel customerModel);

    void removeDuplicatePaymentMethod(String payerEmail);

    CustomerModel getCustomerModel(String payerId);
}
