/*

 */
package com.paypal.hybris.core.service;

import com.paypal.hybris.core.enums.SavedPaymentMethodsLimit;
import com.paypal.hybris.core.model.PayPalPluginConfigurationModel;
import de.hybris.platform.servicelayer.config.ConfigurationService;
import de.hybris.platform.store.BaseStoreModel;

/**
 * This interface is used to service PayPal configuration
 */
public interface PayPalConfigurationService {

    boolean isPayPalConnectAddPaymentMethodFlow();

    boolean isApplePayEnable();

    boolean isL2L3DataEnabled();

    boolean isApplePayOnExpressCheckoutEnable();

    boolean isPayPalEnable();

    String getPayPal3DSVerificationType();

    boolean isExpressCheckoutEnabled();

    boolean isVenmoEnabled();

    boolean isPayLaterEnabledForNonUsCountries();

    boolean isCommitEnabled();

    boolean isReplenishmentAvailable();

    String getClientID();

    String getPayPalPartnerAttributionId();

    int getPayPalExpireBetween();

    boolean isPayPalCreditCardOnAddingValidation();

    boolean isPayPalSaveOrderFlowEnabled();

    boolean isPayPalHostedFieldsVaultEnabled();

    String getPayPalVerifyCCOnMyAccount();

    boolean isPayPalAdditionalSecurityEnabled();

    boolean isPayPalHostedFieldsEnabled();

    boolean isFraudNetEnabled();

    boolean isFraudNetSandboxEnabled();

    String getFraudNetId(String pageType);

    String getSecretKey();

    String getEnvironmentType();

    String getPayPalApiUrl();

    String getPayPalSdkJsUrl();

    String getPayPalIntent();

    String getPayPalIntent(BaseStoreModel baseStore);

    String getNonDecimalCurrency();

    String getPayPalConnectScript();

    String getPayPalConnectScopes();

    String getPayPalConnectResponseType();

    String getPayPalConnectReturnUrl();

    String getPayPalConnectCheckoutReturnUrl();

    boolean isEnableLoginViaPayPalToTheExistingUser();

    String getBuyerCountry();

    String getLocale();

    boolean isConnectWithPayPalIsEnable();

    boolean isSaveOrderFlow();

    void setConfigurationService(ConfigurationService configurationService);

    PayPalPluginConfigurationModel getPayPalPluginConfiguration();

    boolean isLocalPaymentsEnable();

    boolean isThreeDsVerificationOnCheckoutEnable();

    boolean isPayPalVaultEnabled();

    boolean isPayPalVaultFlowEnabled();

    boolean isChangePaymentButtonEnabled();

    SavedPaymentMethodsLimit getSavedCreditCardsLimit();

    SavedPaymentMethodsLimit getSavedPayPalAccountsLimit();

    boolean isThreeDsVerificationOnCheckoutAlwaysRequiredEnable();

}
