package com.paypal.hybris.core.listener;

import com.paypal.hybris.core.event.PayPalEmailNotificationEvent;
import com.paypal.hybris.core.enums.PayPalEmailEvent;
import com.paypal.hybris.core.processcommands.PayPalCreateProcessCommand;
import de.hybris.platform.commerceservices.model.process.StoreFrontCustomerProcessModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.event.impl.AbstractEventListener;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.store.services.BaseStoreService;

import java.util.Map;

public class PayPalEmailNotificationEventListener extends AbstractEventListener<PayPalEmailNotificationEvent> {

    private Map<PayPalEmailEvent, PayPalCreateProcessCommand> processCommandMap;

    private BusinessProcessService businessProcessService;

    private ModelService modelService;

    private BaseStoreService baseStoreService;

    private BaseSiteService baseSiteService;

    private CommonI18NService commonI18NService;

    private UserService userService;

    @Override
    protected void onEvent(PayPalEmailNotificationEvent event) {
        StoreFrontCustomerProcessModel notificationProcess = processCommandMap.get(event.getPayPalEmailEvent()).createProcess();
        notificationProcess.setStore(baseStoreService.getCurrentBaseStore());
        notificationProcess.setLanguage(commonI18NService.getCurrentLanguage());
        notificationProcess.setCurrency(commonI18NService.getCurrentCurrency());
        notificationProcess.setSite(baseSiteService.getCurrentBaseSite());
        notificationProcess.setCustomer((CustomerModel) userService.getUserForUID(event.getUid()));
        modelService.save(notificationProcess);
        businessProcessService.startProcess(notificationProcess);
    }


    public void setBusinessProcessService(BusinessProcessService businessProcessService) {
        this.businessProcessService = businessProcessService;
    }

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void setBaseStoreService(BaseStoreService baseStoreService) {
        this.baseStoreService = baseStoreService;
    }

    public void setBaseSiteService(BaseSiteService baseSiteService) {
        this.baseSiteService = baseSiteService;
    }

    public void setCommonI18NService(CommonI18NService commonI18NService) {
        this.commonI18NService = commonI18NService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setProcessCommandMap(Map<PayPalEmailEvent, PayPalCreateProcessCommand> processCommandMap) {
        this.processCommandMap = processCommandMap;
    }
}
