package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.order.interceptors.DefaultOrderPrepareInterceptor;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;
import de.hybris.platform.servicelayer.interceptor.PersistenceOperation;
import java.util.Optional;

public class DefaultPayPalOrderPrepareInterceptor extends DefaultOrderPrepareInterceptor {

    @Override
    public void onPrepare(Object model, InterceptorContext ctx) throws InterceptorException {
        if (model instanceof OrderModel) {
            super.onPrepare(model, ctx);
            final OrderModel order = (OrderModel) model;
            if (ctx.isNew(order) && order.getPaymentInfo() instanceof PayPalCreditCardPaymentInfoModel) {
                Optional.ofNullable(order.getPaymentTransactions())
                    .ifPresent(txs -> txs.forEach(tx -> {
                        tx.setInfo(order.getPaymentInfo());
                        ctx.registerElementFor(tx, PersistenceOperation.SAVE);
                    }));
            }
        }
    }
}
