package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.enums.PayPalFunding;
import com.paypal.hybris.core.model.PayPalConfigurationModel;
import de.hybris.platform.servicelayer.interceptor.InitDefaultsInterceptor;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;

import java.util.HashSet;
import java.util.Set;

public class DefaultPayPalConfigurationOnInitDefaultsInterceptor implements InitDefaultsInterceptor<PayPalConfigurationModel> {

    private final Set<PayPalFunding> defaultFundingOnBillingPage = new HashSet<>();

    private final Set<PayPalFunding> defaultFundingOnExpressCheckout = new HashSet<>();

    public DefaultPayPalConfigurationOnInitDefaultsInterceptor(){
        defaultFundingOnBillingPage.add(PayPalFunding.PAYPAL);
        defaultFundingOnExpressCheckout.add(PayPalFunding.PAYPAL);
    }
    @Override
    public void onInitDefaults(PayPalConfigurationModel payPalConfigurationModel, InterceptorContext interceptorContext) throws InterceptorException {
        payPalConfigurationModel.setPayPalFundingOnBillingPage(defaultFundingOnBillingPage);
        payPalConfigurationModel.setPayPalFundingOnExpressCheckout(defaultFundingOnExpressCheckout);
    }

    public Set<PayPalFunding> getDefaultFundingOnBillingPage() {
        return defaultFundingOnBillingPage;
    }

    public Set<PayPalFunding> getDefaultFundingOnExpressCheckout() {
        return defaultFundingOnExpressCheckout;
    }
}
