package com.paypal.hybris.core.interceptors;

import com.paypal.hybris.core.enums.LocalPaymentFunding;
import com.paypal.hybris.core.model.LocalPaymentsConfigurationModel;
import de.hybris.platform.servicelayer.interceptor.InitDefaultsInterceptor;
import de.hybris.platform.servicelayer.interceptor.InterceptorContext;
import de.hybris.platform.servicelayer.interceptor.InterceptorException;

import java.util.Arrays;
import java.util.stream.Collectors;

public class DefaultLocalPaymentsConfigurationOnInitDefaultsInterceptor implements InitDefaultsInterceptor<LocalPaymentsConfigurationModel> {
    @Override
    public void onInitDefaults(LocalPaymentsConfigurationModel localPaymentsConfigurationModel, InterceptorContext interceptorContext) throws InterceptorException {
        localPaymentsConfigurationModel.setFundingsOnBillingPage(Arrays.stream(LocalPaymentFunding.values()).collect(Collectors.toSet()));
    }
}