package com.paypal.hybris.core.exception;

public class UnsupportedDeliveryModeException extends Exception
{

    private final String deliveryMode;

    /**
     * @param code
     */
    public UnsupportedDeliveryModeException(final String code)
    {
        super("Delivery Mode [" + code + "] is not supported for the current cart");
        this.deliveryMode = code;
    }


    /**
     * @return the deliveryMode
     */
    public String getDeliveryMode()
    {
        return deliveryMode;
    }

}

