package com.paypal.hybris.core.exception;

import com.paypal.hybris.data.PayPalOrderProcessRequestData;
import org.springframework.http.HttpEntity;
import org.springframework.web.client.HttpClientErrorException;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CHECKOUT_PAYMENT_ERROR_MSG;

public class PayPalVaultedHttpClientErrorException extends PayPalProcessPaymentException {

	private final HttpEntity<PayPalOrderProcessRequestData> request;
	private final HttpClientErrorException parentException;

	public PayPalVaultedHttpClientErrorException(HttpClientErrorException parentException,
												 HttpEntity<PayPalOrderProcessRequestData> request) {
		super(PAYPAL_CHECKOUT_PAYMENT_ERROR_MSG);
		this.request = request;
		this.parentException = parentException;
	}

	public HttpClientErrorException getParentException() {
		return parentException;
	}

	public HttpEntity<PayPalOrderProcessRequestData> getCaptureRequest() {
		return request;
	}
}
