package com.paypal.hybris.core.exception;

import com.paypal.http.HttpRequest;
import com.paypal.payments.Authorization;

import java.io.IOException;

public class PayPalReauthorizeAdapterException extends PayPalAdapterException {

	private final HttpRequest<Authorization> request;
	private final IOException parentException;
	private final String message;

	public PayPalReauthorizeAdapterException(IOException parentException, HttpRequest<Authorization> request, String message) {
		super(parentException);
		this.parentException = parentException;
		this.request = request;
		this.message = message;
	}

	public HttpRequest<Authorization> getRequest() {
		return request;
	}

	public IOException getParentException() {
		return parentException;
	}

	@Override
	public String getMessage() {
		return message;
	}
}
