package com.paypal.hybris.core.exception;

import com.paypal.hybris.data.PayPalOrderProcessRequestData;
import org.springframework.web.client.HttpClientErrorException;

public class PayPalProcessVaultedPaymentException  extends PayPalProcessPaymentException {

	private final PayPalOrderProcessRequestData request;
	private final HttpClientErrorException parentException;

	public PayPalProcessVaultedPaymentException(HttpClientErrorException parentException, PayPalOrderProcessRequestData request, String message) {
		super(message);
		this.request = request;
		this.parentException = parentException;
	}

	public PayPalOrderProcessRequestData getRequest() {
		return request;
	}

	public HttpClientErrorException getParentException() {
		return parentException;
	}
}
