package com.paypal.hybris.core.exception;

import de.hybris.platform.payment.commands.request.AbstractRequest;
import org.springframework.web.client.HttpClientErrorException;


public class PayPalProcessHttpClientErrorException extends PayPalProcessPaymentException {

	private final AbstractRequest request;
	private final HttpClientErrorException parentException;

	public PayPalProcessHttpClientErrorException(HttpClientErrorException parentException, AbstractRequest request, String message) {
		super(message);
		this.request = request;
		this.parentException = parentException;
	}

	public AbstractRequest getRequest() {
		return request;
	}

	public HttpClientErrorException getParentException() {
		return parentException;
	}

}
