package com.paypal.hybris.core.exception;

import de.hybris.platform.payment.commands.request.AbstractRequest;
import org.springframework.web.client.HttpClientErrorException;

import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CHECKOUT_PAYMENT_ERROR_MSG;

public class PayPalHttpClientErrorException extends PayPalProcessPaymentException {

	private final AbstractRequest request;
	private final HttpClientErrorException parentException;

	public PayPalHttpClientErrorException(HttpClientErrorException parentException, AbstractRequest request) {
		super(PAYPAL_CHECKOUT_PAYMENT_ERROR_MSG);
		this.request = request;
		this.parentException = parentException;
	}

	public HttpClientErrorException getParentException() {
		return parentException;
	}

	public AbstractRequest getCaptureRequest() {
		return request;
	}
}
