package com.paypal.hybris.core.exception;

import com.paypal.http.HttpRequest;
import com.paypal.orders.Order;
import de.hybris.platform.payment.AdapterException;

import java.io.IOException;

public class PayPalAuthorizeAdapterException extends AdapterException {
	private final HttpRequest<Order> request;
	private final IOException parentException;

	public PayPalAuthorizeAdapterException(IOException parentException, HttpRequest<Order> request) {
		super(parentException.getMessage());
		this.request = request;
		this.parentException = parentException;
	}

	public HttpRequest<Order> getRequest() {
		return request;
	}

	public IOException getParentException() {
		return parentException;
	}
}
